/* gpaste-applet.c generated by valac 0.22.1, the Vala compiler
 * generated from gpaste-applet.vala, do not modify */

/*
 *      This file is part of GPaste.
 *
 *      Copyright 2011-2013 Marc-Antoine Perennou <Marc-Antoine@Perennou.com>
 *
 *      GPaste is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      GPaste is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with GPaste.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "gpaste-client.h"
#include "gpaste-daemon.h"
#include "gpaste.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>


#define G_PASTE_TYPE_WINDOW (g_paste_window_get_type ())
#define G_PASTE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_PASTE_TYPE_WINDOW, GPasteWindow))
#define G_PASTE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G_PASTE_TYPE_WINDOW, GPasteWindowClass))
#define G_PASTE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_PASTE_TYPE_WINDOW))
#define G_PASTE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_PASTE_TYPE_WINDOW))
#define G_PASTE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G_PASTE_TYPE_WINDOW, GPasteWindowClass))

typedef struct _GPasteWindow GPasteWindow;
typedef struct _GPasteWindowClass GPasteWindowClass;
typedef struct _GPasteWindowPrivate GPasteWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define G_PASTE_TYPE_MAIN (g_paste_main_get_type ())
#define G_PASTE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_PASTE_TYPE_MAIN, GPasteMain))
#define G_PASTE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G_PASTE_TYPE_MAIN, GPasteMainClass))
#define G_PASTE_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_PASTE_TYPE_MAIN))
#define G_PASTE_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_PASTE_TYPE_MAIN))
#define G_PASTE_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G_PASTE_TYPE_MAIN, GPasteMainClass))

typedef struct _GPasteMain GPasteMain;
typedef struct _GPasteMainClass GPasteMainClass;
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GPasteMainPrivate GPasteMainPrivate;

struct _GPasteWindow {
	GtkWindow parent_instance;
	GPasteWindowPrivate * priv;
};

struct _GPasteWindowClass {
	GtkWindowClass parent_class;
};

struct _GPasteWindowPrivate {
	GtkStatusIcon* tray_icon;
	GtkMenu* history;
	GtkMenu* options;
	gboolean needs_repaint;
};

struct _Block1Data {
	int _ref_count_;
	GPasteWindow * self;
	GPasteMain* app;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	guint current;
};

struct _GPasteMain {
	GtkApplication parent_instance;
	GPasteMainPrivate * priv;
};

struct _GPasteMainClass {
	GtkApplicationClass parent_class;
};

struct _GPasteMainPrivate {
	GPasteWindow* window;
	GPasteSettings* settings;
	guint _element_size;
	GPasteClient* _client;
};


static gpointer g_paste_window_parent_class = NULL;
static gpointer g_paste_main_parent_class = NULL;

GType g_paste_window_get_type (void) G_GNUC_CONST;
#define G_PASTE_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), G_PASTE_TYPE_WINDOW, GPasteWindowPrivate))
enum  {
	G_PASTE_WINDOW_DUMMY_PROPERTY
};
GType g_paste_main_get_type (void) G_GNUC_CONST;
GPasteWindow* g_paste_window_new (GPasteMain* app);
GPasteWindow* g_paste_window_construct (GType object_type, GPasteMain* app);
void g_paste_window_fill_history (GPasteWindow* self);
GPasteClient* g_paste_main_get_client (GPasteMain* self);
static void __lambda5_ (GPasteWindow* self);
static void ___lambda5__g_paste_client_changed (GPasteClient* _sender, gpointer self);
static void g_paste_window_fill_options (GPasteWindow* self);
static gboolean __lambda9_ (GPasteWindow* self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void _vala_GdkEvent_free (GdkEvent* self);
static gboolean ___lambda9__gtk_status_icon_button_press_event (GtkStatusIcon* _sender, GdkEventButton* event, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
guint g_paste_main_get_element_size (GPasteMain* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ______lambda3_ (Block2Data* _data2_, GdkEventButton* event);
void g_paste_window_show_history (GPasteWindow* self);
static gboolean _______lambda3__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda6_ (GPasteWindow* self);
static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda7_ (GPasteWindow* self);
static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda8_ (GPasteWindow* self);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void g_paste_window_finalize (GObject* obj);
#define G_PASTE_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), G_PASTE_TYPE_MAIN, GPasteMainPrivate))
enum  {
	G_PASTE_MAIN_DUMMY_PROPERTY,
	G_PASTE_MAIN_ELEMENT_SIZE,
	G_PASTE_MAIN_CLIENT
};
GPasteMain* g_paste_main_new (void);
GPasteMain* g_paste_main_construct (GType object_type);
static void g_paste_main_set_client (GPasteMain* self, GPasteClient* value);
static void g_paste_main_set_element_size (GPasteMain* self, guint value);
static void g_paste_main_init (GPasteMain* self);
static void _g_paste_main_init_g_application_activate (GApplication* _sender, gpointer self);
static void __lambda4_ (GPasteMain* self, const gchar* key);
static void ___lambda4__g_paste_settings_changed (GPasteSettings* _sender, const gchar* object, gpointer self);
static void ___lambda2_ (GPasteMain* self);
static void ____lambda2__g_paste_client_show_history (GPasteClient* _sender, gpointer self);
gint g_paste_main_main (gchar** args, int args_length1);
static void g_paste_main_finalize (GObject* obj);
static void _vala_g_paste_main_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_g_paste_main_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda5_ (GPasteWindow* self) {
	self->priv->needs_repaint = TRUE;
}


static void ___lambda5__g_paste_client_changed (GPasteClient* _sender, gpointer self) {
	__lambda5_ (self);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean __lambda9_ (GPasteWindow* self) {
	gboolean result = FALSE;
	GdkEvent* e = NULL;
	GdkEvent* _tmp0_ = NULL;
	GdkEvent* _tmp1_ = NULL;
	GdkEventButton _tmp2_ = {0};
	guint _tmp3_ = 0U;
	_tmp0_ = gtk_get_current_event ();
	e = _tmp0_;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = _tmp2_.button;
	switch (_tmp3_) {
		case 1:
		{
			gboolean _tmp4_ = FALSE;
			GtkMenu* _tmp5_ = NULL;
			GtkStatusIcon* _tmp6_ = NULL;
			GdkEvent* _tmp7_ = NULL;
			guint32 _tmp8_ = 0U;
			_tmp4_ = self->priv->needs_repaint;
			if (_tmp4_) {
				g_paste_window_fill_history (self);
			}
			_tmp5_ = self->priv->history;
			_tmp6_ = self->priv->tray_icon;
			_tmp7_ = e;
			_tmp8_ = gdk_event_get_time (_tmp7_);
			gtk_menu_popup (_tmp5_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp6_, (guint) 1, _tmp8_);
			break;
		}
		case 3:
		{
			GtkMenu* _tmp9_ = NULL;
			GtkStatusIcon* _tmp10_ = NULL;
			GdkEvent* _tmp11_ = NULL;
			guint32 _tmp12_ = 0U;
			_tmp9_ = self->priv->options;
			_tmp10_ = self->priv->tray_icon;
			_tmp11_ = e;
			_tmp12_ = gdk_event_get_time (_tmp11_);
			gtk_menu_popup (_tmp9_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp10_, (guint) 3, _tmp12_);
			break;
		}
		default:
		break;
	}
	result = FALSE;
	__vala_GdkEvent_free0 (e);
	return result;
}


static gboolean ___lambda9__gtk_status_icon_button_press_event (GtkStatusIcon* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
	return result;
}


GPasteWindow* g_paste_window_construct (GType object_type, GPasteMain* app) {
	GPasteWindow * self = NULL;
	GPasteMain* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	GtkStatusIcon* _tmp2_ = NULL;
	GtkStatusIcon* _tmp3_ = NULL;
	GPasteMain* _tmp4_ = NULL;
	GPasteClient* _tmp5_ = NULL;
	GPasteClient* _tmp6_ = NULL;
	GtkStatusIcon* _tmp7_ = NULL;
	g_return_val_if_fail (G_PASTE_IS_MAIN (app), NULL);
	self = (GPasteWindow*) g_object_new (object_type, "type", GTK_WINDOW_TOPLEVEL, NULL);
	_tmp0_ = app;
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp1_ = gtk_status_icon_new_from_icon_name ("edit-paste");
	_g_object_unref0 (self->priv->tray_icon);
	self->priv->tray_icon = _tmp1_;
	_tmp2_ = self->priv->tray_icon;
	gtk_status_icon_set_tooltip_text (_tmp2_, "GPaste");
	_tmp3_ = self->priv->tray_icon;
	gtk_status_icon_set_visible (_tmp3_, TRUE);
	g_paste_window_fill_history (self);
	_tmp4_ = app;
	_tmp5_ = g_paste_main_get_client (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) ___lambda5__g_paste_client_changed, self, 0);
	g_paste_window_fill_options (self);
	_tmp7_ = self->priv->tray_icon;
	g_signal_connect_object (_tmp7_, "button-press-event", (GCallback) ___lambda9__gtk_status_icon_button_press_event, self, 0);
	return self;
}


GPasteWindow* g_paste_window_new (GPasteMain* app) {
	return g_paste_window_construct (G_PASTE_TYPE_WINDOW, app);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GPasteWindow * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->app);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GPasteWindow * self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean ______lambda3_ (Block2Data* _data2_, GdkEventButton* event) {
	Block1Data* _data1_;
	GPasteWindow * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	{
		GdkEventButton _tmp0_ = {0};
		guint _tmp1_ = 0U;
		_tmp0_ = *event;
		_tmp1_ = _tmp0_.button;
		switch (_tmp1_) {
			case GDK_BUTTON_PRIMARY:
			{
				GPasteMain* _tmp2_ = NULL;
				GPasteClient* _tmp3_ = NULL;
				GPasteClient* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				_tmp2_ = _data1_->app;
				_tmp3_ = g_paste_main_get_client (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _data2_->current;
				g_paste_client_select_sync (_tmp4_, (guint32) _tmp5_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				result = FALSE;
				return result;
			}
			case GDK_BUTTON_SECONDARY:
			{
				GPasteMain* _tmp6_ = NULL;
				GPasteClient* _tmp7_ = NULL;
				GPasteClient* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				_tmp6_ = _data1_->app;
				_tmp7_ = g_paste_main_get_client (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _data2_->current;
				g_paste_client_delete_sync (_tmp8_, (guint32) _tmp9_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				g_paste_window_show_history (self);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = stderr;
		_tmp11_ = _ ("Couldn't update history.\n");
		fprintf (_tmp10_, "%s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean _______lambda3__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda3_ (self, event);
	return result;
}


void g_paste_window_fill_history (GPasteWindow* self) {
	Block1Data* _data1_;
	GtkMenu* _tmp0_ = NULL;
	gboolean history_is_empty = FALSE;
	GtkApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	GPasteMain* _tmp3_ = NULL;
	gboolean _tmp50_ = FALSE;
	GtkMenu* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (G_PASTE_IS_WINDOW (self));
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp0_;
	_tmp1_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_PASTE_TYPE_MAIN, GPasteMain));
	_data1_->app = _tmp3_;
	{
		gchar** hist = NULL;
		GPasteMain* _tmp4_ = NULL;
		GPasteClient* _tmp5_ = NULL;
		GPasteClient* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint hist_length1 = 0;
		gint _hist_size_ = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		guint element_size = 0U;
		GPasteMain* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp4_ = _data1_->app;
		_tmp5_ = g_paste_main_get_client (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_paste_client_get_history_sync (_tmp6_, &_inner_error_);
		hist = _tmp8_;
		hist_length1 = _vala_array_length (_tmp7_);
		_hist_size_ = hist_length1;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp9_ = hist;
		_tmp9__length1 = hist_length1;
		history_is_empty = _tmp9__length1 == 0;
		_tmp10_ = _data1_->app;
		_tmp11_ = g_paste_main_get_element_size (_tmp10_);
		_tmp12_ = _tmp11_;
		element_size = _tmp12_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					gboolean _tmp14_ = FALSE;
					guint _tmp16_ = 0U;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					guint _tmp18_ = 0U;
					gchar* elem = NULL;
					gchar** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					guint _tmp20_ = 0U;
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					GtkMenuItem* item = NULL;
					const gchar* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkLabel* label = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkWidget* _tmp26_ = NULL;
					GtkLabel* _tmp27_ = NULL;
					guint _tmp28_ = 0U;
					guint _tmp37_ = 0U;
					GtkMenuItem* _tmp47_ = NULL;
					GtkMenu* _tmp48_ = NULL;
					GtkMenuItem* _tmp49_ = NULL;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					_tmp14_ = _tmp13_;
					if (!_tmp14_) {
						guint _tmp15_ = 0U;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp16_ = i;
					_tmp17_ = hist;
					_tmp17__length1 = hist_length1;
					if (!(_tmp16_ < ((guint) _tmp17__length1))) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp18_ = i;
					_data2_->current = _tmp18_;
					_tmp19_ = hist;
					_tmp19__length1 = hist_length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp22_ = g_strdup (_tmp21_);
					elem = _tmp22_;
					_tmp23_ = elem;
					_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp23_);
					g_object_ref_sink (_tmp24_);
					item = _tmp24_;
					_tmp25_ = item;
					_tmp26_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_BIN, GtkBin));
					_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_LABEL, GtkLabel));
					label = _tmp27_;
					_tmp28_ = element_size;
					if (_tmp28_ != ((guint) 0)) {
						GtkLabel* _tmp29_ = NULL;
						GtkLabel* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						GtkLabel* _tmp34_ = NULL;
						guint _tmp35_ = 0U;
						GtkLabel* _tmp36_ = NULL;
						_tmp29_ = label;
						_tmp30_ = label;
						_tmp31_ = gtk_label_get_text (_tmp30_);
						_tmp32_ = string_replace (_tmp31_, "\n", " ");
						_tmp33_ = _tmp32_;
						gtk_label_set_label (_tmp29_, _tmp33_);
						_g_free0 (_tmp33_);
						_tmp34_ = label;
						_tmp35_ = element_size;
						gtk_label_set_max_width_chars (_tmp34_, (gint) _tmp35_);
						_tmp36_ = label;
						gtk_label_set_ellipsize (_tmp36_, PANGO_ELLIPSIZE_END);
					}
					_tmp37_ = i;
					if (_tmp37_ == ((guint) 0)) {
						GtkLabel* _tmp38_ = NULL;
						GtkLabel* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						_tmp38_ = label;
						_tmp39_ = label;
						_tmp40_ = gtk_label_get_text (_tmp39_);
						_tmp41_ = g_markup_escape_text (_tmp40_, (gssize) (-1));
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strconcat ("<b>", _tmp42_, NULL);
						_tmp44_ = _tmp43_;
						_tmp45_ = g_strconcat (_tmp44_, "</b>", NULL);
						_tmp46_ = _tmp45_;
						gtk_label_set_markup (_tmp38_, _tmp46_);
						_g_free0 (_tmp46_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp42_);
					}
					_tmp47_ = item;
					g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GTK_TYPE_WIDGET, GtkWidget), "button-release-event", (GCallback) _______lambda3__gtk_widget_button_release_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp48_ = self->priv->history;
					_tmp49_ = item;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_WIDGET, GtkWidget));
					_g_object_unref0 (label);
					_g_object_unref0 (item);
					_g_free0 (elem);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
		}
		hist = (_vala_array_free (hist, hist_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp50_ = history_is_empty;
	if (_tmp50_) {
		GtkMenuItem* item = NULL;
		const gchar* _tmp51_ = NULL;
		GtkMenuItem* _tmp52_ = NULL;
		GtkLabel* label = NULL;
		GtkMenuItem* _tmp53_ = NULL;
		GtkWidget* _tmp54_ = NULL;
		GtkLabel* _tmp55_ = NULL;
		GtkLabel* _tmp56_ = NULL;
		GtkMenu* _tmp57_ = NULL;
		GtkMenuItem* _tmp58_ = NULL;
		_tmp51_ = _ ("(Empty)");
		_tmp52_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp51_);
		g_object_ref_sink (_tmp52_);
		item = _tmp52_;
		_tmp53_ = item;
		_tmp54_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GTK_TYPE_BIN, GtkBin));
		_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GTK_TYPE_LABEL, GtkLabel));
		label = _tmp55_;
		_tmp56_ = label;
		gtk_label_set_selectable (_tmp56_, FALSE);
		_tmp57_ = self->priv->history;
		_tmp58_ = item;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_WIDGET, GtkWidget));
		_g_object_unref0 (label);
		_g_object_unref0 (item);
	}
	self->priv->needs_repaint = FALSE;
	_tmp59_ = self->priv->history;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GTK_TYPE_WIDGET, GtkWidget));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


void g_paste_window_show_history (GPasteWindow* self) {
	GdkEvent* e = NULL;
	GdkEvent* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMenu* _tmp2_ = NULL;
	GtkStatusIcon* _tmp3_ = NULL;
	GdkEvent* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	g_return_if_fail (G_PASTE_IS_WINDOW (self));
	_tmp0_ = gtk_get_current_event ();
	e = _tmp0_;
	_tmp1_ = self->priv->needs_repaint;
	if (_tmp1_) {
		g_paste_window_fill_history (self);
	}
	_tmp2_ = self->priv->history;
	_tmp3_ = self->priv->tray_icon;
	_tmp4_ = e;
	_tmp5_ = gdk_event_get_time (_tmp4_);
	gtk_menu_popup (_tmp2_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp3_, (guint) 1, _tmp5_);
	__vala_GdkEvent_free0 (e);
}


static void __lambda6_ (GPasteWindow* self) {
	GError * _inner_error_ = NULL;
	{
		g_spawn_command_line_async (PKGLIBEXECDIR "/gpaste-settings", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = _ ("Couldn't spawn gpaste-settings.\n");
		fprintf (_tmp0_, "%s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda6_ (self);
}


static void __lambda7_ (GPasteWindow* self) {
	GError * _inner_error_ = NULL;
	{
		GtkApplication* _tmp0_ = NULL;
		GtkApplication* _tmp1_ = NULL;
		GPasteClient* _tmp2_ = NULL;
		GPasteClient* _tmp3_ = NULL;
		_tmp0_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
		_tmp1_ = _tmp0_;
		_tmp2_ = g_paste_main_get_client (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_PASTE_TYPE_MAIN, GPasteMain));
		_tmp3_ = _tmp2_;
		g_paste_client_empty_sync (_tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = _ ("Couldn't empty history.\n");
		fprintf (_tmp4_, "%s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda7_ (self);
}


static void __lambda8_ (GPasteWindow* self) {
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	_tmp0_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
	_tmp1_ = _tmp0_;
	G_APPLICATION_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication))->quit_mainloop (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication));
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ (self);
}


static void g_paste_window_fill_options (GPasteWindow* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenuItem* settings = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	GtkMenuItem* empty = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMenuItem* _tmp5_ = NULL;
	GtkMenu* _tmp6_ = NULL;
	GtkMenuItem* quit = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMenuItem* _tmp8_ = NULL;
	GtkMenu* _tmp9_ = NULL;
	GtkMenu* _tmp10_ = NULL;
	g_return_if_fail (G_PASTE_IS_WINDOW (self));
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->options);
	self->priv->options = _tmp0_;
	_tmp1_ = _ ("Settings");
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp1_);
	g_object_ref_sink (_tmp2_);
	settings = _tmp2_;
	g_signal_connect_object (settings, "activate", (GCallback) ___lambda6__gtk_menu_item_activate, self, 0);
	_tmp3_ = self->priv->options;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (settings, GTK_TYPE_WIDGET, GtkWidget));
	_tmp4_ = _ ("Empty history");
	_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp4_);
	g_object_ref_sink (_tmp5_);
	empty = _tmp5_;
	g_signal_connect_object (empty, "activate", (GCallback) ___lambda7__gtk_menu_item_activate, self, 0);
	_tmp6_ = self->priv->options;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (empty, GTK_TYPE_WIDGET, GtkWidget));
	_tmp7_ = _ ("Quit");
	_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp7_);
	g_object_ref_sink (_tmp8_);
	quit = _tmp8_;
	g_signal_connect_object (quit, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, self, 0);
	_tmp9_ = self->priv->options;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (quit, GTK_TYPE_WIDGET, GtkWidget));
	_tmp10_ = self->priv->options;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (quit);
	_g_object_unref0 (empty);
	_g_object_unref0 (settings);
}


static void g_paste_window_class_init (GPasteWindowClass * klass) {
	g_paste_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GPasteWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = g_paste_window_finalize;
}


static void g_paste_window_instance_init (GPasteWindow * self) {
	self->priv = G_PASTE_WINDOW_GET_PRIVATE (self);
}


static void g_paste_window_finalize (GObject* obj) {
	GPasteWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G_PASTE_TYPE_WINDOW, GPasteWindow);
	_g_object_unref0 (self->priv->tray_icon);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->options);
	G_OBJECT_CLASS (g_paste_window_parent_class)->finalize (obj);
}


GType g_paste_window_get_type (void) {
	static volatile gsize g_paste_window_type_id__volatile = 0;
	if (g_once_init_enter (&g_paste_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GPasteWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g_paste_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPasteWindow), 0, (GInstanceInitFunc) g_paste_window_instance_init, NULL };
		GType g_paste_window_type_id;
		g_paste_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GPasteWindow", &g_define_type_info, 0);
		g_once_init_leave (&g_paste_window_type_id__volatile, g_paste_window_type_id);
	}
	return g_paste_window_type_id__volatile;
}


static void _g_paste_main_init_g_application_activate (GApplication* _sender, gpointer self) {
	g_paste_main_init (self);
}


static void __lambda4_ (GPasteMain* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("element-size")))) {
		switch (0) {
			default:
			{
				GPasteSettings* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				GPasteWindow* _tmp6_ = NULL;
				_tmp4_ = self->priv->settings;
				_tmp5_ = g_paste_settings_get_element_size (_tmp4_);
				g_paste_main_set_element_size (self, (guint) _tmp5_);
				_tmp6_ = self->priv->window;
				g_paste_window_fill_history (_tmp6_);
				break;
			}
		}
	}
}


static void ___lambda4__g_paste_settings_changed (GPasteSettings* _sender, const gchar* object, gpointer self) {
	__lambda4_ (self, object);
}


GPasteMain* g_paste_main_construct (GType object_type) {
	GPasteMain * self = NULL;
	GPasteSettings* _tmp0_ = NULL;
	GPasteSettings* _tmp8_ = NULL;
	guint32 _tmp9_ = 0U;
	GPasteSettings* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GPasteMain*) g_object_new (object_type, "application-id", "org.gnome.GPaste.Applet", NULL);
	_tmp0_ = g_paste_settings_new ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	{
		GPasteClient* _tmp1_ = NULL;
		GPasteClient* _tmp2_ = NULL;
		GPasteClient* _tmp3_ = NULL;
		_tmp2_ = g_paste_client_new_sync (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp3_ = _tmp1_;
		g_paste_main_set_client (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = _ ("Couldn't connect to GPaste daemon");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp4_, "%s: %s\n", _tmp5_, _tmp7_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_paste_settings_get_element_size (_tmp8_);
	g_paste_main_set_element_size (self, (guint) _tmp9_);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), "activate", (GCallback) _g_paste_main_init_g_application_activate, self, 0);
	_tmp10_ = self->priv->settings;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) ___lambda4__g_paste_settings_changed, self, 0);
	return self;
}


GPasteMain* g_paste_main_new (void) {
	return g_paste_main_construct (G_PASTE_TYPE_MAIN);
}


static void ___lambda2_ (GPasteMain* self) {
	GPasteWindow* _tmp0_ = NULL;
	_tmp0_ = self->priv->window;
	g_paste_window_show_history (_tmp0_);
}


static void ____lambda2__g_paste_client_show_history (GPasteClient* _sender, gpointer self) {
	___lambda2_ (self);
}


static void g_paste_main_init (GPasteMain* self) {
	GPasteWindow* _tmp6_ = NULL;
	GPasteWindow* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (G_PASTE_IS_MAIN (self));
	{
		GPasteClient* _tmp0_ = NULL;
		GPasteClient* _tmp1_ = NULL;
		_tmp0_ = self->priv->_client;
		g_paste_client_track_sync (_tmp0_, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp1_ = self->priv->_client;
		g_signal_connect_object (_tmp1_, "show-history", (GCallback) ____lambda2__g_paste_client_show_history, self, 0);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Couldn't connect to GPaste daemon");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp2_, "%s: %s\n", _tmp3_, _tmp5_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = g_paste_window_new (self);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp6_;
	_tmp7_ = self->priv->window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_WIDGET, GtkWidget));
}


gint g_paste_main_main (gchar** args, int args_length1) {
	gint result = 0;
	GPasteMain* app = NULL;
	GPasteMain* _tmp0_ = NULL;
	GPasteMain* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GPasteMain* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp0_ = g_paste_main_new ();
	app = _tmp0_;
	{
		GPasteMain* _tmp1_ = NULL;
		_tmp1_ = app;
		g_application_register (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication), NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Fail to register the gtk application.\n");
		fprintf (_tmp2_, "%s", _tmp3_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (app);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp4_ = app;
	_tmp5_ = g_application_get_is_remote (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_application_get_type (), GApplication));
	if (_tmp5_) {
		result = 0;
		_g_object_unref0 (app);
		return result;
	}
	_tmp6_ = app;
	_tmp7_ = g_application_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_application_get_type (), GApplication), 0, NULL);
	result = _tmp7_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	return g_paste_main_main (argv, argc);
}


guint g_paste_main_get_element_size (GPasteMain* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (G_PASTE_IS_MAIN (self), 0U);
	_tmp0_ = self->priv->_element_size;
	result = _tmp0_;
	return result;
}


static void g_paste_main_set_element_size (GPasteMain* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (G_PASTE_IS_MAIN (self));
	_tmp0_ = value;
	self->priv->_element_size = _tmp0_;
	g_object_notify ((GObject *) self, "element-size");
}


GPasteClient* g_paste_main_get_client (GPasteMain* self) {
	GPasteClient* result;
	GPasteClient* _tmp0_ = NULL;
	g_return_val_if_fail (G_PASTE_IS_MAIN (self), NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}


static void g_paste_main_set_client (GPasteMain* self, GPasteClient* value) {
	GPasteClient* _tmp0_ = NULL;
	GPasteClient* _tmp1_ = NULL;
	g_return_if_fail (G_PASTE_IS_MAIN (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_client);
	self->priv->_client = _tmp1_;
	g_object_notify ((GObject *) self, "client");
}


static void g_paste_main_class_init (GPasteMainClass * klass) {
	g_paste_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GPasteMainPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_g_paste_main_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g_paste_main_set_property;
	G_OBJECT_CLASS (klass)->finalize = g_paste_main_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G_PASTE_MAIN_ELEMENT_SIZE, g_param_spec_uint ("element-size", "element-size", "element-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G_PASTE_MAIN_CLIENT, g_param_spec_object ("client", "client", "client", g_paste_client_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void g_paste_main_instance_init (GPasteMain * self) {
	self->priv = G_PASTE_MAIN_GET_PRIVATE (self);
}


static void g_paste_main_finalize (GObject* obj) {
	GPasteMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G_PASTE_TYPE_MAIN, GPasteMain);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->_client);
	G_OBJECT_CLASS (g_paste_main_parent_class)->finalize (obj);
}


GType g_paste_main_get_type (void) {
	static volatile gsize g_paste_main_type_id__volatile = 0;
	if (g_once_init_enter (&g_paste_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GPasteMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g_paste_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPasteMain), 0, (GInstanceInitFunc) g_paste_main_instance_init, NULL };
		GType g_paste_main_type_id;
		g_paste_main_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "GPasteMain", &g_define_type_info, 0);
		g_once_init_leave (&g_paste_main_type_id__volatile, g_paste_main_type_id);
	}
	return g_paste_main_type_id__volatile;
}


static void _vala_g_paste_main_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GPasteMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G_PASTE_TYPE_MAIN, GPasteMain);
	switch (property_id) {
		case G_PASTE_MAIN_ELEMENT_SIZE:
		g_value_set_uint (value, g_paste_main_get_element_size (self));
		break;
		case G_PASTE_MAIN_CLIENT:
		g_value_set_object (value, g_paste_main_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_g_paste_main_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GPasteMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G_PASTE_TYPE_MAIN, GPasteMain);
	switch (property_id) {
		case G_PASTE_MAIN_ELEMENT_SIZE:
		g_paste_main_set_element_size (self, g_value_get_uint (value));
		break;
		case G_PASTE_MAIN_CLIENT:
		g_paste_main_set_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



